// PPgFiles2.cpp : Implementierungsdatei
//

#include "stdafx.h"
#include "emule.h"
#include "PPgFiles2.h"
#include "emuledlg.h"
#include "Preferences.h"
#include "OtherFunctions.h"
#include "preferencesdlg.h"


// CPPgFiles2-Dialogfeld

IMPLEMENT_DYNAMIC(CPPgFiles2, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgFiles2, CPropertyPage)
	ON_EN_KILLFOCUS(IDC_FIL2_DROPNNP, OnSettingsChange)
	ON_EN_KILLFOCUS(IDC_FIL2_DROPFQ, OnSettingsChange)
	ON_EN_KILLFOCUS(IDC_FIL2_DROPQP, OnSettingsChange)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_FIL2_DROPNNP_CHK, OnBnClickedNNP)
	ON_BN_CLICKED(IDC_FIL2_DROPFQ_CHK, OnBnClickedFQ)
	ON_BN_CLICKED(IDC_FIL2_DROPQP_CHK, OnBnClickedQP)
	ON_EN_CHANGE(IDC_FIL2_DROPQP_VALUE, OnSettingsChange)
//==> Nicehash by CB Mod [shadow2004]
	ON_EN_KILLFOCUS(IDC_FIL2_NH, OnSettingsChange)
//<== Nicehash by CB Mod [shadow2004]
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_FIL2, OnTcnSelchangeTabFiles2) //>>> shadow2004::Tabbed Prefs [TPT] reworked
END_MESSAGE_MAP()

CPPgFiles2::CPPgFiles2()
	: CPropertyPage(CPPgFiles2::IDD)
{
//>>> shadow2004::Tabbed Prefs [TPT] reworked
	m_imageList.DeleteImageList();
	m_imageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 14+1, 0);
	m_imageList.Add(CTempIconLoader(_T("TRANSFER")));
	m_imageList.Add(CTempIconLoader(_T("DROP")));
//<<< shadow2004::Tabbed Prefs [TPT] reworked
}

CPPgFiles2::~CPPgFiles2()
{
}

void CPPgFiles2::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB_FIL2, m_tabCtr); //>>> shadow2004::Tabbed Prefs [TPT] reworked

	DDX_Control(pDX, IDC_FIL2_DROPNNP, m_ctlDropTimerNNP);
	DDX_Control(pDX, IDC_FIL2_DROPFQ, m_ctlDropTimerFQ);
	DDX_Control(pDX, IDC_FIL2_DROPQP, m_ctlDropTimerQP);

//==> Nicehash by CB Mod [shadow2004]
	DDX_Control(pDX, IDC_FIL2_NH, m_ctlNiceHash);
//<== Nicehash by CB Mod [shadow2004]
}

// CPPgFiles2-Meldungshandler

BOOL CPPgFiles2::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
//>>> shadow2004::Tabbed Prefs [TPT] reworked
	InitTab(true);
	m_tabCtr.SetCurSel(1);
//<<< shadow2004::Tabbed Prefs [TPT] reworked
	InitWindowStyles(this);

	LoadSettings();
	Localize();

	return TRUE; 
}

void CPPgFiles2::Localize(void)
{
	if(m_hWnd)
	{

		GetDlgItem(IDC_FIL2_DROPBOX)->SetWindowText(GetResString(IDS_FIL2_DROPBOX));
		GetDlgItem(IDC_FIL2_DROPNNP_CHK)->SetWindowText(GetResString(IDS_FIL2_DROPNNP_CHK));
		GetDlgItem(IDC_FIL2_DROPNNP_LBL1)->SetWindowText(GetResString(IDS_FIL2_DROPNNP_LBL1));
		GetDlgItem(IDC_FIL2_DROPFQ_CHK)->SetWindowText(GetResString(IDS_FIL2_DROPFQ_CHK));
		GetDlgItem(IDC_FIL2_DROPFQ_LBL1)->SetWindowText(GetResString(IDS_FIL2_DROPFQ_LBL1));
		GetDlgItem(IDC_FIL2_DROPQP_CHK)->SetWindowText(GetResString(IDS_FIL2_DROPQP_CHK));
		GetDlgItem(IDC_FIL2_DROPQP_LBL1)->SetWindowText(GetResString(IDS_FIL2_DROPQP_LBL1));
		GetDlgItem(IDC_FIL2_DROPQP_LBL3)->SetWindowText(GetResString(IDS_FIL2_DROPQP_LBL3));

//==> Nicehash by CB Mod [shadow2004]
		GetDlgItem(IDC_FIL2_NHBOX)->SetWindowText(GetResString(IDS_FIL2_NHBOX));
		GetDlgItem(IDC_FIL2_NHHIGH)->SetWindowText(GetResString(IDS_FIL2_NHHIGH));
		GetDlgItem(IDC_FIL2_NHLOW)->SetWindowText(GetResString(IDS_FIL2_NHLOW));
//<== Nicehash by CB Mod [shadow2004]
	}
}

void CPPgFiles2::LoadSettings(void)
{

	CString strBuffer;

	m_ctlDropTimerNNP.SetRange(5, 120);
	m_ctlDropTimerNNP.SetPos(thePrefs.m_iDropSourcesTimerNNS);
	m_ctlDropTimerNNP.SetTicFreq(10);

	strBuffer.Format(_T("%d"), m_ctlDropTimerNNP.GetPos());
	GetDlgItem(IDC_FIL2_DROPNNP_LBL2)->SetWindowText(strBuffer);

	m_ctlDropTimerFQ.SetRange(5, 120);
	m_ctlDropTimerFQ.SetPos(thePrefs.m_iDropSourcesTimerFQ);
	m_ctlDropTimerFQ.SetTicFreq(10);

	strBuffer.Format(_T("%d"), m_ctlDropTimerFQ.GetPos());
	GetDlgItem(IDC_FIL2_DROPFQ_LBL2)->SetWindowText(strBuffer);

	m_ctlDropTimerQP.SetRange(5, 120);
	m_ctlDropTimerQP.SetPos(thePrefs.m_iDropSourcesTimerHQR);
	m_ctlDropTimerQP.SetTicFreq(10);

	strBuffer.Format(_T("%d"), m_ctlDropTimerQP.GetPos());
	GetDlgItem(IDC_FIL2_DROPQP_LBL2)->SetWindowText(strBuffer);

	CheckDlgButton(IDC_FIL2_DROPNNP_CHK, (UINT)thePrefs.m_bDropSourcesNNS);
	CheckDlgButton(IDC_FIL2_DROPFQ_CHK, (UINT)thePrefs.m_bDropSourcesFQ);
	CheckDlgButton(IDC_FIL2_DROPQP_CHK, (UINT)thePrefs.m_bDropSourcesHQR);

	strBuffer.Format(_T("%d"), thePrefs.GetMaxRemoveQRS());
	GetDlgItem(IDC_FIL2_DROPQP_VALUE)->SetWindowText(strBuffer);

	if(IsDlgButtonChecked(IDC_FIL2_DROPNNP_CHK))
	{
		GetDlgItem(IDC_FIL2_DROPNNP)->EnableWindow(TRUE);
		GetDlgItem(IDC_FIL2_DROPNNP_LBL1)->EnableWindow(TRUE);
		GetDlgItem(IDC_FIL2_DROPNNP_LBL2)->EnableWindow(TRUE);
	}
	else
	{
		GetDlgItem(IDC_FIL2_DROPNNP)->EnableWindow(FALSE);
		GetDlgItem(IDC_FIL2_DROPNNP_LBL1)->EnableWindow(FALSE);
		GetDlgItem(IDC_FIL2_DROPNNP_LBL2)->EnableWindow(FALSE);
	}

	if(IsDlgButtonChecked(IDC_FIL2_DROPFQ_CHK))
	{
		GetDlgItem(IDC_FIL2_DROPFQ)->EnableWindow(TRUE);
		GetDlgItem(IDC_FIL2_DROPFQ_LBL1)->EnableWindow(TRUE);
		GetDlgItem(IDC_FIL2_DROPFQ_LBL2)->EnableWindow(TRUE);
	}
	else
	{
		GetDlgItem(IDC_FIL2_DROPFQ)->EnableWindow(FALSE);
		GetDlgItem(IDC_FIL2_DROPFQ_LBL1)->EnableWindow(FALSE);
		GetDlgItem(IDC_FIL2_DROPFQ_LBL2)->EnableWindow(FALSE);
	}

	if(IsDlgButtonChecked(IDC_FIL2_DROPQP_CHK))
	{
		GetDlgItem(IDC_FIL2_DROPQP)->EnableWindow(TRUE);
		GetDlgItem(IDC_FIL2_DROPQP_LBL1)->EnableWindow(TRUE);
		GetDlgItem(IDC_FIL2_DROPQP_LBL2)->EnableWindow(TRUE);
		GetDlgItem(IDC_FIL2_DROPQP_LBL3)->EnableWindow(TRUE);
		GetDlgItem(IDC_FIL2_DROPQP_VALUE)->EnableWindow(TRUE);
	}
	else
	{
		GetDlgItem(IDC_FIL2_DROPQP)->EnableWindow(FALSE);
		GetDlgItem(IDC_FIL2_DROPQP_LBL1)->EnableWindow(FALSE);
		GetDlgItem(IDC_FIL2_DROPQP_LBL2)->EnableWindow(FALSE);
		GetDlgItem(IDC_FIL2_DROPQP_LBL3)->EnableWindow(FALSE);
		GetDlgItem(IDC_FIL2_DROPQP_VALUE)->EnableWindow(FALSE);
	}

//==> Nicehash by CB Mod [shadow2004]
	m_ctlNiceHash.SetRange(0, 100);
	m_ctlNiceHash.SetPos(thePrefs.GetNiceHashLoadWeight());
	m_ctlNiceHash.SetTicFreq(10);

	strBuffer.Format(_T("%d %s"), m_ctlNiceHash.GetPos(), _T("%"));
	GetDlgItem(IDC_FIL2_NHLABEL)->SetWindowText(strBuffer);
//<== Nicehash by CB Mod [shadow2004]
}

BOOL CPPgFiles2::OnApply()
{

	thePrefs.m_iDropSourcesTimerNNS =((uint32)m_ctlDropTimerNNP.GetPos());
	thePrefs.m_iDropSourcesTimerFQ =((uint32)m_ctlDropTimerFQ.GetPos());
	thePrefs.m_iDropSourcesTimerHQR =((uint32)m_ctlDropTimerQP.GetPos());
	thePrefs.SetDropSourcesNNS(IsDlgButtonChecked(IDC_FIL2_DROPNNP_CHK)!=0);
	thePrefs.SetDropSourcesFQ(IsDlgButtonChecked(IDC_FIL2_DROPFQ_CHK)!=0);
	thePrefs.SetDropSourcesHQR(IsDlgButtonChecked(IDC_FIL2_DROPQP_CHK)!=0);

	TCHAR buffer[510];
	if(GetDlgItem(IDC_FIL2_DROPQP_VALUE)->GetWindowTextLength())
	{
		GetDlgItem(IDC_FIL2_DROPQP_VALUE)->GetWindowText(buffer,6);
		thePrefs.SetMaxRemoveQRS((uint16)_tstoi(buffer));
	}
	else
	{
		thePrefs.SetMaxRemoveQRS((uint16)(5000));
	}
//==> Nicehash by CB Mod [shadow2004]
	thePrefs.m_iNiceHashLoadWeight = (uint16) m_ctlNiceHash.GetPos();
//<== Nicehash by CB Mod [shadow2004]

	LoadSettings();
	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgFiles2::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CString strBuffer;
	if (pScrollBar == GetDlgItem(IDC_FIL2_DROPNNP))
	{
		strBuffer.Format(_T("%d"), m_ctlDropTimerNNP.GetPos());
		GetDlgItem(IDC_FIL2_DROPNNP_LBL2)->SetWindowText(strBuffer);

		SetModified(TRUE);
	}
	if (pScrollBar == GetDlgItem(IDC_FIL2_DROPFQ))
	{
		strBuffer.Format(_T("%d"), m_ctlDropTimerFQ.GetPos());
		GetDlgItem(IDC_FIL2_DROPFQ_LBL2)->SetWindowText(strBuffer);

		SetModified(TRUE);
	}
	if (pScrollBar == GetDlgItem(IDC_FIL2_DROPQP))
	{
		strBuffer.Format(_T("%d"), m_ctlDropTimerQP.GetPos());
		GetDlgItem(IDC_FIL2_DROPQP_LBL2)->SetWindowText(strBuffer);

		SetModified(TRUE);
	}

//==> Nicehash by CB Mod [shadow2004]
	if (pScrollBar == GetDlgItem(IDC_FIL2_NH))
	{
		strBuffer.Format(_T("%d %s"), m_ctlNiceHash.GetPos(), _T("%"));
		GetDlgItem(IDC_FIL2_NHLABEL)->SetWindowText(strBuffer);

		SetModified(TRUE);
	}
//<== Nicehash by CB Mod [shadow2004]

	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CPPgFiles2::OnBnClickedNNP()
{
	if(IsDlgButtonChecked(IDC_FIL2_DROPNNP_CHK))
	{
		GetDlgItem(IDC_FIL2_DROPNNP)->EnableWindow(TRUE);
		GetDlgItem(IDC_FIL2_DROPNNP_LBL1)->EnableWindow(TRUE);
		GetDlgItem(IDC_FIL2_DROPNNP_LBL2)->EnableWindow(TRUE);
	}
	else
	{
		GetDlgItem(IDC_FIL2_DROPNNP)->EnableWindow(FALSE);
		GetDlgItem(IDC_FIL2_DROPNNP_LBL1)->EnableWindow(FALSE);
		GetDlgItem(IDC_FIL2_DROPNNP_LBL2)->EnableWindow(FALSE);
	}
	SetModified();
}

void CPPgFiles2::OnBnClickedFQ()
{
	if(IsDlgButtonChecked(IDC_FIL2_DROPFQ_CHK))
	{
		GetDlgItem(IDC_FIL2_DROPFQ)->EnableWindow(TRUE);
		GetDlgItem(IDC_FIL2_DROPFQ_LBL1)->EnableWindow(TRUE);
		GetDlgItem(IDC_FIL2_DROPFQ_LBL2)->EnableWindow(TRUE);
	}
	else
	{
		GetDlgItem(IDC_FIL2_DROPFQ)->EnableWindow(FALSE);
		GetDlgItem(IDC_FIL2_DROPFQ_LBL1)->EnableWindow(FALSE);
		GetDlgItem(IDC_FIL2_DROPFQ_LBL2)->EnableWindow(FALSE);
	}
	SetModified();
}

void CPPgFiles2::OnBnClickedQP()
{
	if(IsDlgButtonChecked(IDC_FIL2_DROPQP_CHK))
	{
		GetDlgItem(IDC_FIL2_DROPQP)->EnableWindow(TRUE);
		GetDlgItem(IDC_FIL2_DROPQP_LBL1)->EnableWindow(TRUE);
		GetDlgItem(IDC_FIL2_DROPQP_LBL2)->EnableWindow(TRUE);
		GetDlgItem(IDC_FIL2_DROPQP_LBL3)->EnableWindow(TRUE);
		GetDlgItem(IDC_FIL2_DROPQP_VALUE)->EnableWindow(TRUE);
	}
	else
	{
		GetDlgItem(IDC_FIL2_DROPQP)->EnableWindow(FALSE);
		GetDlgItem(IDC_FIL2_DROPQP_LBL1)->EnableWindow(FALSE);
		GetDlgItem(IDC_FIL2_DROPQP_LBL2)->EnableWindow(FALSE);
		GetDlgItem(IDC_FIL2_DROPQP_LBL3)->EnableWindow(FALSE);
		GetDlgItem(IDC_FIL2_DROPQP_VALUE)->EnableWindow(FALSE);
	}
	SetModified();
}

//>>> shadow2004::Tabbed Prefs [TPT] reworked
void CPPgFiles2::InitTab(bool firstinit, int Page)
{
	if (firstinit) 
	{
		m_tabCtr.DeleteAllItems();
		m_tabCtr.SetImageList(&m_imageList);
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Files1, GetResString(IDS_FIL1_NAME), 0, (LPARAM)Files1); 
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Files2, GetResString(IDS_FIL2_NAME), 1, (LPARAM)Files2); 
	}

	m_tabCtr.SetCurSel(Page);
}
void CPPgFiles2::OnTcnSelchangeTabFiles2(NMHDR* /*pNMHDR*/, LRESULT *pResult)
{
	int cur_sel = m_tabCtr.GetCurSel();
	theApp.emuledlg->preferenceswnd->SwitchTab(cur_sel);
	*pResult = 0;
}
//<<< shadow2004::Tabbed Prefs [TPT] reworked